function scan=scangen(lidar,ScanType)

[azspeed,elspeed]=scanspeed(lidar);

%setting stationary motor speed value

mstill=0.02; % deg/sec

sweep=1;
scan=[];
switch lower(ScanType)
    case{'stare'}
        % determine indexs for beam stare
        ind=find(abs(azspeed)<=mstill & abs(elspeed)<=mstill);

        if ~isempty(ind)
            scan(sweep).ind=ind;
            scan(sweep).type='STARE';
            sweep=sweep+1;
        end
    case{'rhi'}
        % determine RHI scans

        ind=find(abs(azspeed)<mstill & elspeed>mstill);
        if ~isempty(ind)  %potential candidates for positive RHI Sweep
            poss=find(diff(ind)~=1); %scan must be incremental
            if ~isempty(poss)
                npos=length(poss);
                indlow=ind(1);
                for j=1:npos
                    numpts=ind(poss(j))-indlow;
                    if numpts>10
                        scan(sweep).ind=[indlow:ind(poss(j))];
                        scan(sweep).type='RHI';
                        sweep=sweep+1;
                        indlow=ind(poss(j)+1);
                    end
                end
            else
                if length(ind)>10
                    scan(sweep).ind=ind;
                    scan(sweep).type='RHI';
                    sweep=sweep+1;
                end
            end
        end

        ind=find(abs(azspeed)<mstill & elspeed<-mstill);
        if ~isempty(ind)  %potential candidates for negative RHI Sweep
            poss=find(diff(ind)~=1); %scan must be incremental
            if ~isempty(poss)
                npos=length(poss);
                indlow=ind(1);
                for j=1:npos
                    numpts=ind(poss(j))-indlow;
                    if numpts>10
                        scan(sweep).ind=[indlow:ind(poss(j))];
                        scan(sweep).type='RHI';
                        sweep=sweep+1;
                        indlow=ind(poss(j)+1);
                    end
                end
            else
                if length(ind)>10
                    scan(sweep).ind=ind;
                    scan(sweep).type='RHI';
                    sweep=sweep+1;
                end
            end
        end
    case{'ppi'}
        % determine PPI scans

        ind=find(abs(elspeed)<mstill & azspeed>mstill);
        if ~isempty(ind)  %potential candidates for positive RHI Sweep
            poss=find(diff(ind)~=1); %scan must be incremental
            if ~isempty(poss)
                npos=length(poss);
                indlow=ind(1);
                for j=1:npos
                    numpts=ind(poss(j))-indlow;
                    if numpts>5
                        scan(sweep).ind=[indlow:ind(poss(j))];
                        scan(sweep).type='PPI';
                        sweep=sweep+1;
                        indlow=ind(poss(j)+1);
                    end
                end

            end
        else
            if length(ind)>10
                scan(sweep).ind=ind;
                scan(sweep).type='PPI';
                sweep=sweep+1;
            end
        end

        ind=find(abs(elspeed)<mstill & azspeed<-mstill);
        if ~isempty(ind)  %potential candidates for negative RHI Sweep
            poss=find(diff(ind)~=1); %scan must be incremental
            if ~isempty(poss)
                npos=length(poss);
                indlow=ind(1);
                for j=1:npos
                    numpts=ind(poss(j))-indlow;
                    if numpts>5
                        scan(sweep).ind=[indlow:ind(poss(j))];
                        scan(sweep).type='PPI';
                        sweep=sweep+1;
                        indlow=ind(poss(j)+1);
                    end
                end
            end
        else
            if length(ind)>10
                scan(sweep).ind=ind;
                scan(sweep).type='PPI';
                sweep=sweep+1;
            end
        end
end
nscans=length(scan);
if ~isempty(scan)
for j=1:nscans
    meantime(j)=mean(lidar.timestamp(scan(j).ind));
end
[mt,ind2]=sort(meantime,'ascend');
for j=1:nscans
    scan2(j).ind=scan(ind2(j)).ind;
    scan2(j).type=scan(ind2(j)).type;
    scan2(j).scantime=mt(j);
end
scan=scan2;
end
        

return
end